#include <Wire.h>
#include <Adafruit_PWMServoDriver.h>

// Initialize PCA9685
Adafruit_PWMServoDriver pwm = Adafruit_PWMServoDriver();

#define SERVO_FREQ 50 // Analog servos run at ~50Hz updates

// MG90S Pulse Width Range (Adjust these based on your specific servos)
#define SERVOMIN  150 // Minimum pulse length count (out of 4096)
#define SERVOMAX  500 // Maximum pulse length count (out of 4096)
#define SERVO_MID  325 // Middle position

/*
 * 11 DOF Hexapod Configuration:
 * Usually, a hexapod has 12 or 18 DOF. With 11 DOF, one leg might be fixed 
 * or you have a specific custom arrangement. 
 * Below is a template for mapping servos to PCA9685 channels (0-10).
 */

void setup() {
  Serial.begin(115200);
  Serial.println("11 DOF Hexapod Initializing...");

  pwm.begin();
  pwm.setOscillatorFrequency(27000000);
  pwm.setPWMFreq(SERVO_FREQ);

  // Center all servos
  for (int i = 0; i < 11; i++) {
    pwm.setPWM(i, 0, SERVO_MID);
    delay(100);
  }

  delay(1000);
}

void loop() {
  // Simple test sweep for all 11 servos
  Serial.println("Testing Servos...");
  
  // Sweep from Mid to Max
  for (uint16_t pulselen = SERVO_MID; pulselen < SERVOMAX; pulselen++) {
    for (int i = 0; i < 11; i++) pwm.setPWM(i, 0, pulselen);
    delay(2);
  }
  
  delay(500);

  // Sweep from Max to Min
  for (uint16_t pulselen = SERVOMAX; pulselen > SERVOMIN; pulselen--) {
    for (int i = 0; i < 11; i++) pwm.setPWM(i, 0, pulselen);
    delay(2);
  }

  delay(500);
  
  // Back to Mid
  for (uint16_t pulselen = SERVOMIN; pulselen < SERVO_MID; pulselen++) {
    for (int i = 0; i < 11; i++) pwm.setPWM(i, 0, pulselen);
    delay(2);
  }

  delay(2000);
}
