# Otto DIY Biped Robot

## Overview
**Otto DIY** is an open source, 3D printable biped robot designed to make learning robotics, electronics, and embedded programming approachable and hands on. The Otto Biped model can walk, dance, react to its environment, and be extended with new behaviors and hardware modules.

---

## Key Features
- Fully 3D printable biped robot body  
- Microcontroller based control system  
- Walking, dancing, and expressive motion using micro servos  
- Obstacle detection with ultrasonic sensor  
- Sound output using a buzzer  
- Modular and extensible hardware design  
- Programmed entirely through Embedr  

---

## Hardware Requirements
- Microcontroller board compatible with Otto  
- 4x micro servo motors  
- Ultrasonic distance sensor  
- Buzzer  
- Battery and power switch  
- 3D printed body parts  
- Screws, wires, and basic tools  

---

## Software Requirements
- Embedr account  
- Otto firmware and project files available in this directory  

---

## Getting Started
1. 3D print the Otto Biped body parts or use a pre printed kit  
2. Assemble the servos, electronics, and wiring  
3. Open this project in Embedr  
4. Configure components and behavior through prompts and project files  
5. Flash the firmware and power on Otto  

---

## What You Will Learn
- Embedded systems fundamentals  
- Servo control and motion sequencing  
- Sensor integration and feedback loops  
- Behavior driven robotics programming  
- End to end hardware and firmware workflows  

---

## Customization
Otto is designed to be hacked and extended. You can:
- Add sensors such as Bluetooth, IR, or LEDs  
- Modify or remix the 3D models  
- Create custom walking gaits and animations  
- Build interactive behaviors using Embedr prompts  

---

## Use Cases
- STEAM and robotics education  
- Beginner embedded systems projects  
- Maker and DIY robotics experiments  
- Prototyping expressive robot behaviors  

---

## License
Otto DIY is an open source project. Hardware designs, firmware, and documentation are released under open licenses. Refer to the official OttoDIY documentation for exact license details.

---

## Learn More
Official website: https://www.ottodiy.com  
Community tutorials, designs, and extensions are available through the OttoDIY ecosystem.
